/************************************************************************/
/* File name     : p_lex.h                                              */
/************************************************************************/
/* Written by    : Stefan Friebe, BID PL24 R&D, 12/08/97                */
/* Last modified : ask clearcase                                        */
/************************************************************************/
/* File contents :                                                      */
/*                pattern term string condition parser                  */
/*                function prototypes and defines                       */ 
/************************************************************************/
/* NOTES :                                                              */
/************************************************************************/

#include "xbddefs.h"


/* stack size of yacc parser. Dont worry, if this value is too small,   */
/* yacc issues an error.                                                */

#define YYMAXDEPTH  32


/* define signal types */
#define LISTTYPE   0
#define VECTORTYPE 1
#define BITTYPE    2
#define COMBTYPE   3


/* define parser output */

#define BUS_PATT        0
#define OBS_PATT        1
#define ERR_PATT        2
#define TRAN_PATT       3


/* define parser errors */

#define UNDEFINED_TOKEN          100
#define SYNTAX_ERROR             101
#define WRONG_PARSEDEST_DPT      102
#define WRONG_PARSEDEST_SPT      103
#define MORE_THAN_ONE_LISTSIGNAL 104

/* type definition for parser communication variable yylval */

typedef struct { bx_int32 dc_bits;
                 bx_int32 c_bits;
               } t_numval;

typedef struct {
                 bx_int32 C_value;
                 bx_int32 DC_value;
                 bx_int8  Type;
                 bx_int8  Length;
                 bx_int8  Position;
                 bx_int8  Index;
               } t_signal_idx;

#if 0 /* defined BEST_DEBUG remove the 0 to make this dependent of debug... HL */
/* Always use it with two bracket pairs, e.g.
   DBG_OUT(("A=%lu B=%lu C=%lu\n",a,b,c));
   This makes the preprocessor handle it as only one 
   parameter (containing multiple parameters enclosed
   in brackets).
*/
#include "xutil.h"
#define DBG_OUT(a)          BESTX_PRINTF a
#else
#define DBG_OUT(a)          (void) (0)
#endif


/* c_pattern[] and dc_pattern[] dimensions */
#if 0
#define BX_PATTARR_SIZE_F (4+2+4)   /* 4 DWs (=128 bit for 29er/Mephisto) plus 2 DWs for DDR plus 4 DWs for QDR AD lines */            
#define BX_PATTARR_SIZE_M (4)       /* 4 DWs (=128 bit for 29er/Mephisto) */            
#else
#define BX_PATTARR_SIZE (4)       /* 4 DWs (=128 bit for 29er/30er) */            
#endif

/* global array that holds the c and dc pattern for E2929A */
/* first it is initialized to all dc  */
extern bx_int32 c_pattern[];
extern bx_int32 dc_pattern[];

/* global variable that indicates whether the pattern term is always zero */
extern bx_bool  global_zero;


/* some function prototypes */

bx_errtype parse_eqn(bx_handletype, bx_charptrtype, bx_patttype, bx_bool);
void conv_string_to_int(char* ,int ,bx_int32* ,bx_int32* );
int  yy_patt_lex();
int  yy_patt_parse();
int  yy_patt_error(char *s);
int  is_ascii(char c);





